# MODAVA API Endpoints Summary

This document lists all available API endpoints for the MODAVA backend. Update this file as you add or change endpoints.

---

## Authentication Endpoints

### `POST /api/auth/signup`
**Description:** Register a new user and create a vendor profile.
**Auth Required:** No

**Request Body:**
```json
{
  "email": "vendor@example.com",
  "password": "securepassword",
  "business_name": "Fashion Studio" // optional
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "user": { /* Supabase user object */ },
    "vendor": { /* Vendor profile */ },
    "access_token": "jwt_token",
    "refresh_token": "refresh_token"
  },
  "message": "User registered successfully"
}
```

---

### `POST /api/auth/login`
**Description:** Login an existing user.
**Auth Required:** No

**Request Body:**
```json
{
  "email": "vendor@example.com",
  "password": "securepassword"
}
```

**Response:**
```json
{
  "success": true,
  "data": {
    "user": { /* Supabase user object */ },
    "vendor": { /* Vendor profile */ },
    "access_token": "jwt_token",
    "refresh_token": "refresh_token"
  },
  "message": "Login successful"
}
```

---

### `GET /api/auth/profile`
**Description:** Get the current user's profile.
**Auth Required:** Yes (Bearer token)

**Response:**
```json
{
  "success": true,
  "data": {
    "user": { /* Supabase user object */ },
    "vendor": { /* Vendor profile */ }
  }
}
```

---

### `POST /api/auth/logout`
**Description:** Logout the current user.
**Auth Required:** Yes (Bearer token)

**Response:**
```json
{
  "success": true,
  "message": "Logged out successfully"
}
```

---

## Vendor Endpoints

### `GET /api/vendors/me`
**Description:** Get the current vendor's profile.
**Auth Required:** Yes (Bearer token)

**Response:**
```json
{
  "success": true,
  "data": { /* Vendor profile */ }
}
```

---

### `POST /api/vendors/onboarding`
**Description:** Complete vendor onboarding.
**Auth Required:** Yes (Bearer token)

**Request Body:**
```json
{
  "business_name": "Fashion Studio",
  "profile_picture_url": "https://example.com/photo.jpg" // optional
}
```

**Response:**
```json
{
  "success": true,
  "data": { /* Updated vendor profile */ },
  "message": "Onboarding completed successfully"
}
```

---

### `PUT /api/vendors/profile`
**Description:** Update vendor profile.
**Auth Required:** Yes (Bearer token)

**Request Body:**
```json
{
  "business_name": "Updated Studio Name",
  "profile_picture_url": "https://example.com/new-photo.jpg",
  "subscription_plan": "premium"
}
```

**Response:**
```json
{
  "success": true,
  "data": { /* Updated vendor profile */ },
  "message": "Profile updated successfully"
}
```

---

### `GET /api/vendors/:id`
**Description:** Get vendor by ID (admin only).
**Auth Required:** Yes (admin role)

**Response:**
```json
{
  "success": true,
  "data": { /* Vendor profile */ }
}
```

---

### `GET /api/vendors`
**Description:** Get all vendors (admin only).
**Auth Required:** Yes (admin role)

**Response:**
```json
{
  "success": true,
  "data": [ /* Array of vendor profiles */ ]
}
```

---

## Authentication
All protected endpoints require a Bearer token in the `Authorization` header:
```
Authorization: Bearer <supabase_access_token>
```

---

## Updating This Document
- Add new endpoints as you build new features.
- Update request/response examples as needed.
- Indicate if endpoints are admin-only or require special roles. 

---

## Subscriptions & Feature Gate Endpoints

### `GET /api/subscriptions/plans`
**Description:** List all available subscription plans.
**Auth Required:** No (public)

---

### `POST /api/subscriptions/plans`
**Description:** Create a new subscription plan.
**Auth Required:** Yes (admin)

---

### `PUT /api/subscriptions/plans/:id`
**Description:** Update a subscription plan.
**Auth Required:** Yes (admin)

---

### `DELETE /api/subscriptions/plans/:id`
**Description:** Soft-delete a subscription plan.
**Auth Required:** Yes (admin)

---

### `GET /api/subscriptions/my-plan`
**Description:** Get the current vendor's active plan and trial status.
**Auth Required:** Yes (vendor)

---

### `POST /api/subscriptions/activate`
**Description:** Activate or switch to a new plan for the current vendor.
**Auth Required:** Yes (vendor)

---

### `GET /api/subscriptions/trial-offer`
**Description:** Get trial settings and eligibility for the current vendor.
**Auth Required:** Yes (vendor)

---

### `POST /api/subscriptions/accept-trial`
**Description:** Accept a trial for the current vendor.
**Auth Required:** Yes (vendor)

---

### `GET /api/subscriptions/features`
**Description:** List all features (admin only).
**Auth Required:** Yes (admin)

---

### `PUT /api/subscriptions/features/:id`
**Description:** Update a feature (admin only).
**Auth Required:** Yes (admin)

---

### `POST /api/subscriptions/features/assign`
**Description:** Assign a feature to a plan (admin only).
**Auth Required:** Yes (admin)

---

### `POST /api/subscriptions/features/remove`
**Description:** Remove a feature from a plan (admin only).
**Auth Required:** Yes (admin)

---

### `PUT /api/subscriptions/trial-settings`
**Description:** Update trial settings (admin only).
**Auth Required:** Yes (admin)

---

### `GET /api/subscriptions/my-features`
**Description:** Get the list of enabled feature keys for the current user (feature gate).
**Auth Required:** Yes (vendor)

--- 

---

## AI Assistant Service Layer Endpoints

### `POST /api/ai/generate-reminder`
**Description:** Generate a smart reminder message for a client.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/ai/generate-greeting`
**Description:** Generate a personalized greeting for a client.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/ai/generate-shopping-assist`
**Description:** Help vendor complete a shopping list with AI suggestions.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/ai/generate-price-insight`
**Description:** Suggest a price for an item based on market trends.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/ai/general`
**Description:** General-purpose AI assistant (raw prompt + context).
**Auth Required:** Yes (vendor, feature-gated)

--- 

---

## Reminders Module Endpoints

### `POST /api/reminders/create`
**Description:** Create a new reminder (manual or AI-generated).
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/reminders/list`
**Description:** List all reminders for the current vendor.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/reminders/send/:id`
**Description:** Send the reminder to the customer (simulated send).
**Auth Required:** Yes (vendor, feature-gated)

--- 

---

## Shopping Lists & Orders Module Endpoints

### `POST /api/shop/shopping-lists`
**Description:** Create a new shopping list for the logged-in vendor. Auto-creates canonical items if needed.
**Auth Required:** Yes (vendor)

---

### `GET /api/shop/shopping-lists/:id/match-sellers`
**Description:** Get seller matches for a shopping list. Returns sellers grouped by match score and matched items.
**Auth Required:** Yes (vendor)

---

### `POST /api/shop/orders`
**Description:** Create an order from a selected seller and shopping list. Pulls prices from seller inventory.
**Auth Required:** Yes (vendor)

---

### `GET /api/shop/orders`
**Description:** Get all orders for the logged-in vendor. Supports filtering by status.
**Auth Required:** Yes (vendor)

---

### `PATCH /api/shop/orders/:id`
**Description:** Update the status of an order (confirmed, fulfilled, cancelled). Only the vendor can update.
**Auth Required:** Yes (vendor)

--- 

---

## Customer Management Module Endpoints

### `GET /api/customers`
**Description:** List all customers for the vendor, with optional search and tag filters.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/customers`
**Description:** Add or link a customer to the vendor, with tags.
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/customers/:customerId`
**Description:** View a customer’s profile, tags, and measurements.
**Auth Required:** Yes (vendor, feature-gated)

---

### `PUT /api/customers/:customerId`
**Description:** Update vendor-specific fields (tags, display name) for a customer.
**Auth Required:** Yes (vendor, feature-gated)

---

### `POST /api/customers/:customerId/measurements`
**Description:** Add or update measurements for this customer.
**Auth Required:** Yes (vendor, feature-gated)

---

### `DELETE /api/customers/:customerId`
**Description:** Unlink customer from this vendor (does not delete global profile).
**Auth Required:** Yes (vendor, feature-gated)

--- 

---

## Invoicing Module Endpoints

### `POST /api/invoices`
**Description:** Create a new invoice (linked or unlinked customer). Generates a public link and PDF.
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/invoices/view/:public_code`
**Description:** View invoice (public, no auth). Returns vendor, items, total, status, payment buttons, PDF link.
**Auth Required:** No (public)

---

### `POST /api/invoices/:id/mark-paid`
**Description:** Mark invoice as paid (payment gateway callback). Updates status, logs transaction, triggers payout.
**Auth Required:** Internal webhook

---

### `GET /api/invoices`
**Description:** Get all invoices for the vendor (with filters for status, currency, date).
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/invoices/:id/download`
**Description:** Download PDF for invoice (authenticated vendor).
**Auth Required:** Yes (vendor, feature-gated)

---

### `DELETE /api/invoices/:id`
**Description:** Delete invoice (only if pending).
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/invoices/transactions`
**Description:** Get all successful payments for vendor (invoice-based).
**Auth Required:** Yes (vendor, feature-gated)

--- 

---

## KYC Module Endpoints

### `POST /api/kyc/submit`
**Description:** Vendor submits or updates KYC details and documents. Sets status to pending_review.
**Auth Required:** Yes (vendor)

---

### `GET /api/kyc/status`
**Description:** Vendor checks their KYC status (pending_review, approved, rejected, reason, submitted_at).
**Auth Required:** Yes (vendor)

---

### `GET /api/kyc/admin/pending`
**Description:** Admin lists all pending KYC submissions (paginated).
**Auth Required:** Yes (admin)

---

### `POST /api/kyc/admin/:vendorId/review`
**Description:** Admin reviews and approves/rejects a KYC submission. Updates status, logs action.
**Auth Required:** Yes (admin)

--- 

---

## Greeting Scheduler Module Endpoints

### `POST /api/greetings/templates`
**Description:** Create or update a greeting template for a type (birthday, anniversary, first_order).
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/greetings/templates`
**Description:** Get all greeting templates for the vendor.
**Auth Required:** Yes (vendor, feature-gated)

---

### `PATCH /api/greetings/settings`
**Description:** Enable or disable greeting types for the vendor.
**Auth Required:** Yes (vendor, feature-gated)

---

### `GET /api/greetings/logs`
**Description:** View sent/skipped/failed greeting logs (filterable by type, status, date).
**Auth Required:** Yes (vendor, feature-gated)

--- 

---

## Contributors & Discounts Module Endpoints

### Contributors (Team plan only)

#### `POST /api/contributors`
**Description:** Add a contributor (team member) with role and permissions.
**Auth Required:** Yes (vendor, feature-gated: contributor_roles)

---

#### `GET /api/contributors`
**Description:** List all contributors for the current vendor.
**Auth Required:** Yes (vendor, feature-gated: contributor_roles)

---

#### `PATCH /api/contributors/:id`
**Description:** Update contributor’s role or permissions.
**Auth Required:** Yes (vendor, feature-gated: contributor_roles)

---

#### `DELETE /api/contributors/:id`
**Description:** Remove (soft delete) a contributor.
**Auth Required:** Yes (vendor, feature-gated: contributor_roles)

---

### Discounts (Pro/Team plans)

#### `POST /api/contributors/discounts`
**Description:** Create a discount (product/order/customer).
**Auth Required:** Yes (vendor, feature-gated: discount_rules)

---

#### `GET /api/contributors/discounts`
**Description:** List discounts (with filters).
**Auth Required:** Yes (vendor, feature-gated: discount_rules)

---

#### `GET /api/contributors/discounts/apply`
**Description:** Get best discounts for cart/customer.
**Auth Required:** Yes (vendor, feature-gated: discount_rules)

---

#### `PATCH /api/contributors/discounts/:id`
**Description:** Update discount details or deactivate.
**Auth Required:** Yes (vendor, feature-gated: discount_rules)

---

#### `DELETE /api/contributors/discounts/:id`
**Description:** Soft delete or mark discount as inactive.
**Auth Required:** Yes (vendor, feature-gated: discount_rules)

--- 

---

## Referrals Module Endpoints

### `POST /api/referrals`
**Description:** Register a referral during signup. Stores referrer and referred user, prevents self-referral.
**Auth Required:** Yes (user, feature-gated: referrals)

---

### `GET /api/referrals`
**Description:** List users referred by the current user, with status and reward info.
**Auth Required:** Yes (user, feature-gated: referrals)

---

### `GET /api/referrals/summary`
**Description:** Get referral summary for the current user (total, qualified, pending, earned, paid out).
**Auth Required:** Yes (user, feature-gated: referrals)

---

### `PATCH /api/referrals/admin/:id`
**Description:** Admin approves or rejects a referral reward. Logs action in audit table.
**Auth Required:** Yes (admin)

--- 

---

## Notifications Module Endpoints

### `GET /api/notifications`
**Description:** Get all notifications for the logged-in user (with filters for status, type, date).
**Auth Required:** Yes (user)

---

### `PATCH /api/notifications/:id/read`
**Description:** Mark a notification as read for the current user.
**Auth Required:** Yes (user)

---

### `DELETE /api/notifications/:id`
**Description:** Soft delete notification from user’s inbox.
**Auth Required:** Yes (user)

---

### `POST /api/notifications/send`
**Description:** Send notification (admin or system service). Supports push delivery if enabled.
**Auth Required:** Yes (admin/system)

--- 

---

## Market Prices Module Endpoints

### `POST /api/market-prices`
**Description:** Submit a market price for a product/market (pricing agent/admin only). Prevents duplicate for same product/market/day.
**Auth Required:** Yes (user, must have can_update_prices or admin)

---

### `GET /api/market-prices`
**Description:** List market prices (with filters for market, product, contributor, date).
**Auth Required:** Yes (user)

---

### `GET /api/market-prices/suggestions`
**Description:** Get price suggestions for vendor’s market (requires feature gate).
**Auth Required:** Yes (vendor, feature-gated: market_price_suggestions)

---

### `PATCH /api/market-prices/admin/users/:id/pricing-access`
**Description:** Admin approves or rejects pricing agent access.
**Auth Required:** Yes (admin, super admin only)

--- 

---

## Sketches Module Endpoints

### `POST /api/sketches`
**Description:** Upload a sketch (file + metadata, stored in Supabase Storage). Returns sketch metadata and file URL.
**Auth Required:** Yes (vendor, feature-gated: sketch_upload)

---

### `POST /api/sketches/:id/enhance`
**Description:** Request AI enhancement (beautify/svg). Only allowed if vendor has feature and device is desktop/tablet for SVG.
**Auth Required:** Yes (vendor, feature-gated: ai_sketch_enhance, deviceGuard for SVG)

---

### `GET /api/sketches`
**Description:** List all sketches for the vendor (with filters for customer, invoice, tags).
**Auth Required:** Yes (vendor)

---

### `GET /api/sketches/:id`
**Description:** Get a single sketch (must belong to vendor).
**Auth Required:** Yes (vendor)

---

### `DELETE /api/sketches/:id`
**Description:** Delete a sketch (if not linked to finalized invoice).
**Auth Required:** Yes (vendor)

--- 

---

## Admin Module Endpoints

### `GET /api/admin/users`
**Description:** List all admins (super admin only).
**Auth Required:** Yes (super admin)

---

### `POST /api/admin/users`
**Description:** Create admin or assign role (super admin only).
**Auth Required:** Yes (super admin)

---

### `PATCH /api/admin/users/:id/permissions`
**Description:** Update admin permissions (super admin only).
**Auth Required:** Yes (super admin)

---

### `GET /api/admin/settings`
**Description:** View global admin/system settings.
**Auth Required:** Yes (admin, edit_settings permission)

---

### `PATCH /api/admin/settings`
**Description:** Update global settings.
**Auth Required:** Yes (admin, edit_settings permission)

---

### `GET /api/admin/logs`
**Description:** View admin activity logs (super admin only).
**Auth Required:** Yes (super admin)

---

### `PATCH /api/admin/feature-flags`
**Description:** Toggle global feature flags.
**Auth Required:** Yes (admin, edit_settings permission)

---

### `PATCH /api/admin/kyc/:id`
**Description:** Approve/reject KYC or pricing agent requests.
**Auth Required:** Yes (admin, approve_kyc permission)

---

### `POST /api/admin/impersonate`
**Description:** Admin impersonates a vendor/user (super admin only).
**Auth Required:** Yes (super admin)

---

### `GET /api/admin/audit-trail`
**Description:** View audit trail of key table changes (super admin only).
**Auth Required:** Yes (super admin)

---

### `GET /api/admin/support-tickets`
**Description:** View support ticket inbox.
**Auth Required:** Yes (admin, resolve_tickets permission)

---

### `PATCH /api/admin/support-tickets/:id`
**Description:** Resolve or update support ticket.
**Auth Required:** Yes (admin, resolve_tickets permission)

---

### `GET /api/admin/notifications`
**Description:** List admin notifications (flagged actions, etc.).
**Auth Required:** Yes (admin)

--- 

---

## Withdrawals & Payouts Module Endpoints

### `GET /api/withdrawals`
**Description:** View withdrawal history and wallet summary for the vendor.
**Auth Required:** Yes (vendor)

---

### `PATCH /api/vendors/bank-account`
**Description:** Update vendor bank account (max once per 30 days).
**Auth Required:** Yes (vendor)

---

### `PATCH /api/withdrawals/admin/vendors/:id/withdrawal-status`
**Description:** Admin pause/resume withdrawals for a vendor.
**Auth Required:** Yes (admin)

---

### `PATCH /api/withdrawals/admin/withdrawals/global-status`
**Description:** Admin pause/resume withdrawals globally.
**Auth Required:** Yes (admin)

---

### `POST /api/withdrawals/admin/withdrawals/trigger`
**Description:** Admin manually triggers withdrawal job (CRON/worker).
**Auth Required:** Yes (admin)

--- 

---

## Consultation Forms Module Endpoints

### `POST /api/consultations/forms`
**Description:** Create a new consultation form with questions.
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

---

### `GET /api/consultations/forms`
**Description:** List all consultation forms for the vendor.
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

---

### `GET /api/consultations/forms/:id`
**Description:** Get form details with questions (public endpoint for customers).
**Auth Required:** No

---

### `POST /api/consultations/forms/:form_id/respond`
**Description:** Submit a consultation form response.
**Auth Required:** No (public endpoint)

---

### `GET /api/consultations/forms/:id/responses`
**Description:** Get all responses for a consultation form.
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

---

### `GET /api/consultations/forms/:id/analytics`
**Description:** Get analytics for a consultation form.
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

---

### `POST /api/consultations/forms/:id/duplicate`
**Description:** Duplicate an existing consultation form.
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

---

### `PATCH /api/consultations/forms/:id/status`
**Description:** Update consultation form status (draft/active/inactive).
**Auth Required:** Yes (vendor)
**Feature Gate:** `consultation_forms`

--- 

---

## Sellers Management Module Endpoints

### `POST /api/sellers`
**Description:** Create new seller profile.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `GET /api/sellers`
**Description:** List all sellers created by current admin/supervendor.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `GET /api/sellers/:id`
**Description:** Get seller profile by ID.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `PUT /api/sellers/:id`
**Description:** Update seller details.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `DELETE /api/sellers/:id`
**Description:** Soft delete/archive seller (marks as inactive).
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `POST /api/sellers/:id/inventory`
**Description:** Add or update seller inventory item.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `GET /api/sellers/:id/inventory`
**Description:** List all items sold by this seller.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `PUT /api/sellers/:id/inventory/:item_id`
**Description:** Update inventory item.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `DELETE /api/sellers/:id/inventory/:item_id`
**Description:** Remove inventory item.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `POST /api/sellers/:id/assign-order`
**Description:** Assign seller to shopping list item.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `PUT /api/sellers/:id/mark-fulfilled`
**Description:** Mark seller order as fulfilled.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

---

### `GET /api/sellers/:id/analytics`
**Description:** Get seller analytics and performance metrics.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `manage_sellers`

--- 

---

## Debug Module Endpoints

### `GET /api/debug/ping`
**Description:** Basic health check endpoint.
**Auth Required:** No

---

### `GET /api/debug/supabase`
**Description:** Test Supabase connection and list accessible tables.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `GET /api/debug/user/:user_id`
**Description:** Get comprehensive user debug information.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `POST /api/debug/feature-check`
**Description:** Check if a user has access to a specific feature.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `POST /api/debug/subscription-check`
**Description:** Get detailed subscription information for a vendor.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `POST /api/debug/ai-log`
**Description:** Test AI service and log the interaction.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `GET /api/debug/system-status`
**Description:** Get comprehensive system health status.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

---

### `GET /api/debug/cache`
**Description:** Show cached features for a user.
**Auth Required:** Yes (admin/staff/supervendor)
**Feature Gate:** `allow_debug_tools`

--- 